<?php

namespace Diogenes\DiogenesClient\Model;

/**
 * Description of AddressType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class AddressType {
    
    const STANDARD = "STANDARD";
    const PEC = "PEC";
    const UNKNOWN = "UNKNOWN";
    
    const TYPES = [self::STANDARD, self::PEC, self::UNKNOWN];

    private $domain;
    private $type;
    private $lastUpdate;
   
    public function __construct($domain, $type, $lastUpdate = null) {
        $this->domain = $domain;
        $this->type = $type;
        $this->lastUpdate = $lastUpdate;
    }
    
    public function getDomain() {
        return $this->domain;
    }

    public function getType() {
        return $this->type;
    }

    public function getLastUpdate() {
        return $this->lastUpdate;
    }
    
    public static function unknownType($domain) {
        return new self($domain, self::UNKNOWN);
    }

}
